/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	CUtility.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CApplication.h"

HRESULT AddSet(ISet *set1, ISet *set2)
{
	START_METHOD("AddSet")

	HRESULT status = NOERROR;

	// Getting the Iterator
	IIt *pIt = NULL;
	status = (GetCLASS(It))->CreateAObjectIt(set2, &pIt);
	CHECK_RETURN_STATUS(status)

	IDispatch *pDisp = NULL;
	pIt->start(&pDisp);
	while (pDisp) {
		status = set1->AddMember(CAST(IObjectOrSet, pDisp));
		CHECK_RETURN_STATUS(status)
		pDisp = NULL;
		pIt->Next(&pDisp);
	}

	END_METHOD("AddSet")
}

void TraceStartMethod(const CString &method)
{
	TRACE1("Calling Function %s \n", method);
}

void OnMethodFailure(HRESULT status)
{
	ASSERT(FALSE);

	AfxThrowOleException(status);
}
